/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.PushEntityMessage;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class CompiledExtruderModule1
extends CompiledModule {
    public static final String NBT_EXTRUDER_DIST = "ExtruderDist";
    private static final double BASE_PUSH_STRENGTH = 0.55;
    private static final double AUGMENT_BOOST = 0.15;
    int distance;
    private final int pushingAugments;
    private final ItemStack pickaxe;

    public CompiledExtruderModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.distance = router == null ? 0 : router.getExtensionData().m_128451_(NBT_EXTRUDER_DIST + this.getFacing());
        this.pushingAugments = this.getAugmentCount((Item)ModItems.PUSHING_AUGMENT.get());
        ItemStack itemStack = this.pickaxe = stack.m_41720_() instanceof IPickaxeUser ? ((IPickaxeUser)stack.m_41720_()).getPickaxe(stack) : ItemStack.f_41583_;
        if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && EnchantmentHelper.m_44831_((ItemStack)this.pickaxe).isEmpty()) {
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)stack), (ItemStack)this.pickaxe);
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean extend = this.shouldExtend(router);
        Level world = router.nonNullLevel();
        if (extend && !router.isBufferEmpty() && this.distance < this.getRange() && this.isRegulationOK(router, false)) {
            BlockPos placePos = router.m_58899_().m_5484_(this.getFacing(), this.distance + 1);
            ItemStack toPlace = router.peekBuffer(1);
            BlockState state = BlockUtil.tryPlaceAsBlock(router, toPlace, world, placePos, this.getFacing());
            if (state != null) {
                router.extractBuffer(1);
                router.getExtensionData().m_128405_(NBT_EXTRUDER_DIST + this.getFacing(), ++this.distance);
                if (((Boolean)ConfigHolder.common.module.extruderSound.get()).booleanValue()) {
                    router.playSound(null, placePos, state.m_60734_().getSoundType(state, (LevelReader)world, placePos, null).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                this.tryPushEntities(router.m_58904_(), placePos, this.getFacing());
                return true;
            }
        } else if (!extend && this.distance > 0 && this.isRegulationOK(router, true)) {
            BlockPos breakPos = router.m_58899_().m_5484_(this.getFacing(), this.distance);
            BlockState oldState = world.m_8055_(breakPos);
            Block oldBlock = oldState.m_60734_();
            if (world.m_46859_(breakPos) || oldBlock instanceof LiquidBlock) {
                router.getExtensionData().m_128405_(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                return false;
            }
            BlockUtil.BreakResult dropResult = BlockUtil.tryBreakBlock(router, world, breakPos, this.getFilter(), this.pickaxe, false);
            if (dropResult.isBlockBroken()) {
                router.getExtensionData().m_128405_(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                dropResult.processDrops(world, breakPos, router.getBuffer());
                if (((Boolean)ConfigHolder.common.module.extruderSound.get()).booleanValue()) {
                    router.playSound(null, breakPos, oldBlock.getSoundType(oldState, (LevelReader)world, breakPos, null).m_56775_(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    void tryPushEntities(Level world, BlockPos placePos, Direction facing) {
        if (!((Boolean)ConfigHolder.common.module.extruderPushEntities.get()).booleanValue()) {
            return;
        }
        Vec3 v = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.55 + (double)this.pushingAugments * 0.15);
        for (Entity entity : world.m_45976_(Entity.class, new AABB(placePos))) {
            if (entity.m_7752_() == PushReaction.IGNORE) continue;
            entity.m_20256_(v);
            entity.m_6853_(false);
            entity.f_19862_ = false;
            entity.f_19863_ = false;
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_6862_(true);
            }
            PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new PushEntityMessage(entity, v));
        }
    }

    @Override
    public boolean shouldRun(boolean powered, boolean pulsed) {
        return true;
    }

    boolean shouldExtend(ModularRouterBlockEntity router) {
        return switch (this.getRedstoneBehaviour()) {
            case RouterRedstoneBehaviour.ALWAYS -> {
                if (router.getRedstonePower() > 0) {
                    yield true;
                }
                yield false;
            }
            case RouterRedstoneBehaviour.HIGH -> {
                if (router.getRedstonePower() == 15) {
                    yield true;
                }
                yield false;
            }
            case RouterRedstoneBehaviour.LOW -> {
                if (router.getRedstonePower() == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

